/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.data.image;

import dev.quantumfusion.dashloader.api.DashDependencies;
import dev.quantumfusion.dashloader.api.DashObject;
import dev.quantumfusion.dashloader.data.image.DashImage;
import dev.quantumfusion.dashloader.data.image.DashSprite;
import dev.quantumfusion.dashloader.data.image.DashSpriteAnimation;
import dev.quantumfusion.dashloader.mixin.accessor.MipmapHelperAccessor;
import dev.quantumfusion.dashloader.mixin.accessor.NativeImageAccessor;
import dev.quantumfusion.dashloader.mixin.accessor.SpriteAccessor;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import dev.quantumfusion.dashloader.registry.RegistryWriter;
import dev.quantumfusion.dashloader.util.DashUtil;
import dev.quantumfusion.dashloader.util.UnsafeHelper;
import dev.quantumfusion.hyphen.scan.annotations.DataNullable;
import net.minecraft.class_1011;
import net.minecraft.class_1058;

@DashObject(value=class_1058.class)
@DashDependencies(value={DashImage.class})
public class DashSpriteImpl
implements DashSprite {
    @DataNullable
    public final DashSpriteAnimation animation;
    public final int image;
    public final boolean imageTransparent;
    public final int images;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final float uMin;
    public final float uMax;
    public final float vMin;
    public final float vMax;

    public DashSpriteImpl(DashSpriteAnimation animation, int image, boolean imageTransparent, int images, int x, int y, int width, int height, float uMin, float uMax, float vMin, float vMax) {
        this.animation = animation;
        this.image = image;
        this.imageTransparent = imageTransparent;
        this.images = images;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.uMin = uMin;
        this.uMax = uMax;
        this.vMin = vMin;
        this.vMax = vMax;
    }

    public DashSpriteImpl(class_1058 sprite, RegistryWriter writer) {
        this.animation = DashUtil.nullable(sprite.method_33443(), animation -> new DashSpriteAnimation((class_1058.class_5790)animation, writer));
        class_1011[] images = ((SpriteAccessor)sprite).getImages();
        class_1011 image = images[0];
        this.image = writer.add(image);
        boolean transparent = false;
        block0: for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4323(); ++y) {
                if (image.method_4315(x, y) >> 24 != 0) continue;
                transparent = true;
                break block0;
            }
        }
        this.imageTransparent = transparent;
        this.images = images.length;
        this.x = sprite.method_35806();
        this.y = sprite.method_35807();
        this.width = sprite.method_4578();
        this.height = sprite.method_4595();
        this.uMin = sprite.method_4594();
        this.uMax = sprite.method_4577();
        this.vMin = sprite.method_4593();
        this.vMax = sprite.method_4575();
    }

    @Override
    public class_1058 export(RegistryReader registry) {
        class_1058 out = UnsafeHelper.allocateInstance(class_1058.class);
        SpriteAccessor spriteAccessor = (SpriteAccessor)out;
        class_1011[] images = new class_1011[this.images];
        images[0] = (class_1011)registry.get(this.image);
        for (int i = 1; i <= this.images - 1; ++i) {
            class_1011 oldLevel = images[i - 1];
            class_1011 newLevel = new class_1011(oldLevel.method_4307() >> 1, oldLevel.method_4323() >> 1, false);
            int newWidth = newLevel.method_4307();
            int newHeight = newLevel.method_4323();
            long oldPtr = ((NativeImageAccessor)oldLevel).getPointer();
            long newPtr = ((NativeImageAccessor)newLevel).getPointer();
            int oldWidth = oldLevel.method_4307();
            for (int x = 0; x < newWidth; ++x) {
                for (int y = 0; y < newHeight; ++y) {
                    int one = DashSpriteImpl.getColorUnsafe(oldPtr, oldWidth, x * 2, y * 2);
                    int two = DashSpriteImpl.getColorUnsafe(oldPtr, oldWidth, x * 2 + 1, y * 2);
                    int three = DashSpriteImpl.getColorUnsafe(oldPtr, oldWidth, x * 2, y * 2 + 1);
                    int four = DashSpriteImpl.getColorUnsafe(oldPtr, oldWidth, x * 2 + 1, y * 2 + 1);
                    int color = MipmapHelperAccessor.blend(one, two, three, four, this.imageTransparent);
                    DashSpriteImpl.setColorUnsafe(newPtr, newWidth, x, y, color);
                }
            }
            images[i] = newLevel;
        }
        spriteAccessor.setImages(images);
        spriteAccessor.setX(this.x);
        spriteAccessor.setY(this.y);
        spriteAccessor.setWidth(this.width);
        spriteAccessor.setHeight(this.height);
        spriteAccessor.setUMin(this.uMin);
        spriteAccessor.setUMax(this.uMax);
        spriteAccessor.setVMin(this.vMin);
        spriteAccessor.setVMax(this.vMax);
        spriteAccessor.setAnimation(DashUtil.nullable(this.animation, animation -> animation.export(out, registry)));
        return out;
    }

    private static int getColorUnsafe(long ptr, int oldWidth, int x, int y) {
        return UnsafeHelper.UNSAFE.getInt(ptr + ((long)x + (long)y * (long)oldWidth) * 4L);
    }

    private static void setColorUnsafe(long ptr, int width, int x, int y, int color) {
        UnsafeHelper.UNSAFE.putInt(ptr + ((long)x + (long)y * (long)width) * 4L, color);
    }
}

